/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChopMod;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.Setting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;

public class ConfirmedSetting
extends Setting {
    protected final Event event;

    public ConfirmedSetting(Setting setting, Event event) {
        super(setting.getField(), setting.getValue());
        this.event = event;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        super.encode(buffer);
        this.event.encode(buffer);
    }

    public static ConfirmedSetting decode(PacketBuffer buffer) {
        Setting setting = Setting.decode(buffer);
        Event event = Event.decode(buffer);
        return new ConfirmedSetting(setting, event);
    }

    public static enum Event {
        ACCEPT{

            @Override
            public void run(ConfirmedSetting setting) {
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    String fieldName = setting.getField().getFancyName();
                    String valueName = setting.getField().getValueName(setting.getValue());
                    if (((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get()).booleanValue()) {
                        TreeChopMod.showText(String.format("%s %s", fieldName, valueName));
                    }
                }
            }
        }
        ,
        DENY{

            @Override
            public void run(ConfirmedSetting setting) {
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    String fieldName = setting.getField().getFancyName();
                    String valueName = setting.getField().getValueName(setting.getValue());
                    if (((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get()).booleanValue()) {
                        TreeChopMod.showText(String.format("%s %s %s(%s)", fieldName, valueName, TextFormatting.RED, I18n.func_135052_a((String)"treechop.setting.missing_permissions", (Object[])new Object[0])));
                    }
                }
            }
        }
        ,
        SILENT;

        private static final Event[] values;

        public void run(ConfirmedSetting message) {
        }

        public static Event decode(PacketBuffer buffer) {
            int ordinal = buffer.readByte() % values.length;
            return values[ordinal];
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeByte(this.ordinal());
        }

        static {
            values = Event.values();
        }
    }
}

